import sys
sys.setrecursionlimit(300000)
input = sys.stdin.readline
class TrieNode:
    __slots__ = ("children", "end")
    def __init__(self):
        self.children = [None] * 10
        self.end = -1
def solve():
    n = int(input())
    a = list(map(int, input().split()))
    nums = [str(x) for x in a]
    root = TrieNode()
    for idx, s in enumerate(nums):
        node = root
        for ch in s:
            c = ord(ch) - ord('0')
            if not node.children[c]:
                node.children[c] = TrieNode()
            node = node.children[c]
        node.end = idx
    def dfs(node):
        sets = []
        for c in range(10):
            child = node.children[c]
            if child:
                sets.extend(dfs(child))
        if node.end != -1:
            if not sets:
                sets = [[node.end]]
            else:
                sets[0].append(node.end)
        return sets
    groups = dfs(root)
    print(len(groups))
    for g in groups:
        print(len(g))
        print(' '.join(str(a[i]) for i in g))
if __name__ == "__main__":
    solve()